.TH %asn 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
%asn - elliptic integral
.SH CALLING SEQUENCE
.nf
[y]=%asn(x,m)
.fi
.SH PARAMETERS
.TP
x
: upper limit of integral (\fVx>0\fR) (can be a vector)
.TP
m
: parameter of integral (\fV0<m<1\fR)
.TP
y
: value of the integral
.SH DESCRIPTION
Calculates the elliptic integral
.IG
.nf
 y = integral from 0 to x of [1/(((1-t*t)^(1/2))(1-m*t*t)^(1/2))]
.fi
.FI
.LA $$ K= \int_0^x  {dt \over [(1-t^2)(1-m t^2)]^{1/2}} $$
If \fVx\fR is a vector, \fVy\fR is a vector of same dimension as \fVx\fR.
.SH EXAMPLE
.nf
m=0.8;z=%asn(1/sqrt(m),m);K=real(z);Ktilde=imag(z);
x2max=1/sqrt(m);
x1=0:0.05:1;x2=1:((x2max-1)/20):x2max;x3=x2max:0.05:10;
x=[x1,x2,x3];
y=%asn(x,m);
rect=[0,-Ktilde,1.1*K,2*Ktilde];
plot2d(real(y)',imag(y)',1,'011',' ',rect)
//
deff('y=f(t)','y=1/sqrt((1-t^2)*(1-m*t^2))');
intg(0,0.9,f)-%asn(0.9,m)  //Works for real case only!
.fi
.SH AUTHOR
F. D.
